let editor = null;
let isRunning = false;

function initEditor() {
    editor = ace.edit('editor');
    editor.setTheme('ace/theme/dracula');
    editor.session.setMode('ace/mode/javascript');
    editor.setOptions({
        fontSize: '15px',
        showPrintMargin: false,
        showLineNumbers: true,
        showGutter: true,
        highlightActiveLine: true,
        enableBasicAutocompletion: true,
        enableLiveAutocompletion: true
    });
}

function setModeForLang(lang) {
    if (lang === 'js') editor.session.setMode('ace/mode/javascript');
    else if (lang === 'py') editor.session.setMode('ace/mode/python');
    else if (lang === 'cpp') editor.session.setMode('ace/mode/c_cpp');
    else if (lang === 'rb') editor.session.setMode('ace/mode/ruby');
    else if (lang === 'go') editor.session.setMode('ace/mode/golang');
}

async function runHandler() {
    if (isRunning) return;
    isRunning = true;

    const code = editor.getValue();
    const lang = document.getElementById('lang').value;

    const runBtn = document.getElementById('run-btn');
    runBtn.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i> Running...';
    runBtn.disabled = true;

    document.getElementById('console').innerHTML = `<div class="console-line pulse"><i class="fa-solid fa-gears mr-2"></i>Executing code...</div>`;

    try {
        const res = await fetch(location.pathname + '?action=run', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ lang, code })
        });
        const j = await res.json();
        const r = j.result;
        let consoleContent = '';

        if (!j.ok) {
            consoleContent = `<div class="console-line console-error"><i class="fa-solid fa-bug mr-2"></i>Error: ${j.msg}</div>`;
        } else {
            if (r.timed) {
                consoleContent += `<div class="console-line console-error"><i class="fa-solid fa-clock mr-2"></i>TIMEOUT - Proses eksekusi terlalu lama</div>`;
            }
            if (r.stdout) {
                consoleContent += `<div class="console-line">${r.stdout.replace(/\n/g, '<br>')}</div>`;
            }
            if (r.stderr) {
                consoleContent += `<div class="console-line console-error"><i class="fa-solid fa-circle-exclamation mr-2"></i>${r.stderr.replace(/\n/g, '<br>')}</div>`;
            }
            if (!r.stdout && !r.stderr && !r.timed) {
                consoleContent = `<div class="console-line"><i class="fa-solid fa-info-circle mr-2"></i>Tidak ada output yang dihasilkan</div>`;
            }
        }
        document.getElementById('console').innerHTML = consoleContent;

    } catch (error) {
        document.getElementById('console').innerHTML = `<div class="console-line console-error"><i class="fa-solid fa-circle-exclamation mr-2"></i>Network error: ${error.message}</div>`;
    } finally {
        runBtn.innerHTML = '<i class="fa-solid fa-play"></i> Run Code';
        runBtn.disabled = false;
        isRunning = false;
    }
}


window.addEventListener('DOMContentLoaded', () => {
    initEditor();

    document.getElementById('run-btn').addEventListener('click', runHandler);

    document.getElementById('lang').addEventListener('change', () => {
        setModeForLang(document.getElementById('lang').value);
    });
});