<?php
function executeCode($lang, $code, $input = '') {
    $timeout=10;
    $id=uniqid('run_');
    $dir=sys_get_temp_dir()."/".$id;
    mkdir($dir,0700,true);
    $out=['stdout'=>'','stderr'=>'','exit'=>-1,'timed'=>false];
    try{
        if(in_array($lang,['js','javascript'])){
            $file='code.js';file_put_contents($dir.'/'.$file,$code);
            $cmd="docker run --rm -i -m 256m --network none -v " . escapeshellarg($dir).":/code node:18 bash -c \"timeout {$timeout}s node /code/".$file."\"";
        }elseif(in_array($lang,['py','python'])){
            $file='code.py';file_put_contents($dir.'/'.$file,$code);
            $cmd="docker run --rm -i -m 256m --network none -v " . escapeshellarg($dir).":/code python:3.11-slim bash -c \"timeout {$timeout}s python /code/".$file."\"";
        }elseif(in_array($lang,['cpp','c++'])){
            $file='code.cpp';file_put_contents($dir.'/'.$file,$code);
            $cmd="docker run --rm -i -m 512m --network none -v " . escapeshellarg($dir).":/code gcc:12 bash -c \"g++ /code/".$file." -O2 -std=c++17 -o /code/a.out && timeout {$timeout}s /code/a.out\"";
        }elseif(in_array($lang,['rb','ruby'])){
            $file='code.rb';file_put_contents($dir.'/'.$file,$code);
            $cmd="docker run --rm -i -m 256m --network none -v " . escapeshellarg($dir).":/code ruby:3.2 bash -c \"timeout {$timeout}s ruby /code/".$file."\"";
        }elseif(in_array($lang,['go','golang'])){
            $file='main.go';file_put_contents($dir.'/'.$file,$code);
            $cmd="docker run --rm -i -m 512m --network none -v " . escapeshellarg($dir).":/code golang:1.20 bash -c \"cd /code && timeout {$timeout}s go run " . $file ."\"";
        }else{
            return ['stderr' => 'Unsupported language'];
        }
        $descriptors=[0=>['pipe','r'],1=>['pipe','w'],2=>['pipe','w']];
        $proc=proc_open($cmd,$descriptors,$pipes,null,null);
        if(is_resource($proc)){
            fwrite($pipes[0], $input);
            fclose($pipes[0]);
            $out['stdout']=stream_get_contents($pipes[1]);
            $out['stderr']=stream_get_contents($pipes[2]);
            fclose($pipes[1]);fclose($pipes[2]);
            $status=proc_get_status($proc);
            $out['exit']=$status['exitcode'];
            if($out['exit'] == 124) $out['timed'] = true; // Timeout exit code
            proc_close($proc);
        }else{$out['stderr']='proc_open failed';}
    }catch(Exception $e){$out['stderr']=$e->getMessage();}
    if(is_dir($dir)){$files=scandir($dir);foreach($files as $f)if($f!='.'&&$f!='..')@unlink($dir.'/'.$f);@rmdir($dir);}
    return $out;
}

if($_SERVER['REQUEST_METHOD']==='POST'&&isset($_GET['action'])){
    header('Content-Type: application/json');
    if($_GET['action']==='run'){
        $body=json_decode(file_get_contents('php://input'),true)?:[];
        $lang=($body['lang']??'js');
        $code=($body['code']??'');
        $result = executeCode($lang, $code, '');
        echo json_encode(['ok'=>true,'result'=>$result]);
        exit;
    }
    http_response_code(400);echo json_encode(['ok'=>false,'msg'=>'unknown action']);exit;
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Reconit - Code Compiler</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
<script src="https://cdn.tailwindcss.com"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/ace/1.11.2/ace.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
    :root {
        --bg: #0d1117;
        --card: #161b22;
        --accent: #58a6ff;
        --accent-hover: #4695f7;
        --border: #30363d;
    }
    body {
        font-family: 'Inter', sans-serif;
        background-color: var(--bg);
        color: #e6edf3;
        overflow-x: hidden;
    }
    .editor { width: 100%; height: 500px; border-radius: 0.75rem; overflow: hidden; border: 1px solid var(--border); }
    .ace_editor { background-color: #282a36 !important; }
    .ace_gutter { background: #21222c !important; }
    #console .console-line, #input { padding: 4px 8px; border-radius: 4px; margin-bottom: 2px; display: block; white-space: pre-wrap; word-break: break-all; }
    #console .console-error { color: #ff7b72; background-color: rgba(255, 123, 114, 0.1); }
    .pulse { animation: pulse-animation 1.5s cubic-bezier(0.4, 0, 0.6, 1) infinite; }
    @keyframes pulse-animation { 50% { opacity: .5; } }
</style>
</head>
<body class="min-h-screen text-gray-200">
<div class="max-w-screen-2xl mx-auto p-4 sm:p-6 lg:p-8">
<header class="flex items-center justify-between mb-8">
    <div class="flex items-center flex-1">
        <img src="assets/gambar/logo.png" alt="Reconit-" class="h-12">
    </div>
    <nav class="flex justify-center flex-1">
        <div class="flex items-center gap-2 bg-[color:var(--card)] border border-[color:var(--border)] p-1 rounded-lg">
            <a href="index.php" class="px-5 py-1.5 rounded-md text-gray-400 hover:text-white hover:bg-white/5 font-medium text-sm transition-colors">Quiz</a>
            <a href="compiler.php" class="px-5 py-1.5 rounded-md bg-[color:var(--accent)] text-white font-medium text-sm transition-colors">Compiler</a>
        </div>
    </nav>
    <div class="flex-1"></div> <!-- Spacer to center the nav -->
</header>
<main>
    <div class="bg-[color:var(--card)] p-5 rounded-xl border border-[color:var(--border)]">
        <div class="flex flex-wrap gap-4 mb-4 items-center">
            <div class="relative">
                <select id="lang" class="bg-[#0d1117] border border-[color:var(--border)] rounded-lg px-4 py-2.5 appearance-none focus:ring-2 focus:ring-[color:var(--accent)] focus:border-[color:var(--accent)] pr-10">
                    <option value="js">JavaScript</option>
                    <option value="py">Python</option>
                    <option value="cpp">C++</option>
                    <option value="rb">Ruby</option>
                    <option value="go">Go</option>
                </select>
                <div class="absolute inset-y-0 right-0 flex items-center px-2 pointer-events-none">
                    <i class="fa-solid fa-chevron-down text-gray-400"></i>
                </div>      
            </div>
        </div>
        <div id="editor" class="editor mb-4"></div>
        <div>
            <div class="flex items-center gap-2 mb-3">
                <i class="fa-solid fa-terminal text-gray-400"></i>
                <h3 class="font-semibold">Console Output</h3>
            </div>
            <div class="bg-black/30 p-2 rounded-lg border border-[color:var(--border)] h-48 overflow-auto">
                <pre id="console" class="text-sm font-mono"></pre>
            </div>
        </div>
        <div class="mt-6">
            <button id="run-btn" class="px-6 py-3 rounded-lg bg-[color:var(--accent)] hover:bg-[color:var(--accent-hover)] text-white font-medium flex items-center gap-2 transition-colors">
                <i class="fa-solid fa-play"></i> Run Code
            </button>
        </div>
    </div>
</main>
</div>
<script src="assets/js/compiler.js"></script>
</body>
</html>