<?php
session_start();

function executeCode($lang, $code) {
    $timeout=10;
    $id=uniqid('run_');
    $dir=sys_get_temp_dir()."/".$id;
    mkdir($dir,0700,true);
    $out=['stdout'=>'','stderr'=>'','exit'=>-1,'timed'=>false];
    try{
        if(in_array($lang,['js','javascript'])){
            $file='code.js';file_put_contents($dir.'/'.$file,$code);
            $cmd="docker run --rm -m 256m --network none -v " . escapeshellarg($dir).":/code node:18 bash -c \"timeout {$timeout}s node /code/".$file."\"";
        }elseif(in_array($lang,['py','python'])){
            $file='code.py';file_put_contents($dir.'/'.$file,$code);
            $cmd="docker run --rm -m 256m --network none -v " . escapeshellarg($dir).":/code python:3.11-slim bash -c \"timeout {$timeout}s python /code/".$file."\"";
        }elseif(in_array($lang,['cpp','c++'])){
            $file='code.cpp';file_put_contents($dir.'/'.$file,$code);
            $cmd="docker run --rm -m 512m --network none -v " . escapeshellarg($dir).":/code gcc:12 bash -c \"g++ /code/".$file." -O2 -std=c++17 -o /code/a.out && timeout {$timeout}s /code/a.out\"";
        }elseif(in_array($lang,['csharp','cs'])){
            $file='Program.cs';file_put_contents($dir.'/'.$file,$code);
            $cmd="docker run --rm -m 512m --network none -v " . escapeshellarg($dir).":/code mcr.microsoft.com/dotnet/sdk:7.0 bash -c \"cd /code && mcs -out:program.exe " . "/code/".$file." && timeout {$timeout}s mono program.exe\"";
        }elseif(in_array($lang,['rb','ruby'])){
            $file='code.rb';file_put_contents($dir.'/'.$file,$code);
            $cmd="docker run --rm -m 256m --network none -v " . escapeshellarg($dir).":/code ruby:3.2 bash -c \"timeout {$timeout}s ruby /code/".$file."\"";
        }elseif(in_array($lang,['go','golang'])){
            $file='main.go';file_put_contents($dir.'/'.$file,$code);
            $cmd="docker run --rm -m 512m --network none -v " . escapeshellarg($dir).":/code golang:1.20 bash -c \"cd /code && timeout {$timeout}s go run " . $file ."\"";
        }else{
            return ['stderr' => 'Unsupported language'];
        }
        $descriptors=[0=>['pipe','r'],1=>['pipe','w'],2=>['pipe','w']];
        $proc=proc_open($cmd,$descriptors,$pipes,null,null);
        if(is_resource($proc)){
            fclose($pipes[0]);
            $out['stdout']=stream_get_contents($pipes[1]);
            $out['stderr']=stream_get_contents($pipes[2]);
            fclose($pipes[1]);fclose($pipes[2]);
            $status=proc_get_status($proc);
            $out['exit']=$status['exitcode'];
            if($out['exit'] == 124) $out['timed'] = true; // Timeout exit code
            proc_close($proc);
        }else{$out['stderr']='proc_open failed';}
    }catch(Exception $e){$out['stderr']=$e->getMessage();}
    if(is_dir($dir)){$files=scandir($dir);foreach($files as $f)if($f!='.'&&$f!='..')@unlink($dir.'/'.$f);@rmdir($dir);}
    return $out;
}

$questions = [
    ['id'=>1,'title'=>'Tambah Dua Angka','description'=>'Tulis fungsi `add(a,b)` yang mengembalikan jumlah dari dua angka yang diberikan.','function_name'=>'add','test_cases'=>[['inputs'=>[2,3],'expected'=>5],['inputs'=>[-10,10],'expected'=>0],['inputs'=>[123,456],'expected'=>579]],
    'template_js'=>"function add(a, b) {\n  \n}",
    'template_py'=>"def add(a, b):\n  pass",
    'template_cpp'=>"#include <iostream>\n\nint add(int a, int b) {\n  \n}",
    'template_csharp'=>"using System;\n\nclass Program {\n  static int add(int a, int b) {\n    \n  }\n}",
    'template_rb'=>"def add(a, b)\n  \nend",
    'template_go'=>"package main\n\nfunc add(a int, b int) int {\n  \n}",
    'expected_output'=>'5', 'points' => 10],

    ['id'=>2,'title'=>'Balik String','description'=>'Buat fungsi `reverse` yang membalikkan sebuah string.','function_name'=>'reverse','test_cases'=>[['inputs'=>['hello'],'expected'=>'olleh'],['inputs'=>['world'],'expected'=>'dlrow'],['inputs'=>['racecar'],'expected'=>'racecar']],
    'template_js'=>"function reverse(s) {\n  \n}",
    'template_py'=>"def reverse(s):\n  pass",
    'template_cpp'=>"#include <iostream>\n#include <string>\n\nstd::string reverse(std::string s) {\n  \n}",
    'template_csharp'=>"using System;\n\nclass Program {\n  static string reverse(string s) {\n    \n  }\n}",
    'template_rb'=>"def reverse(s)\n  \nend",
    'template_go'=>"package main\n\nimport \"fmt\"\n\nfunc reverse(s string) string {\n  \n}",
    'expected_output'=>'olleh', 'points' => 20],

    ['id'=>3, 'title'=>'Cek Bilangan Prima', 'description'=>'Buat fungsi `isPrime(n)` yang mengembalikan `true` jika `n` adalah bilangan prima, dan `false` jika tidak. Bilangan prima adalah bilangan lebih besar dari 1 yang hanya bisa dibagi oleh 1 dan dirinya sendiri.', 'function_name'=>'isPrime', 'test_cases'=>[['inputs'=>[7],'expected'=>true],['inputs'=>[10],'expected'=>false],['inputs'=>[1],'expected'=>false],['inputs'=>[29],'expected'=>true]],
    'template_js'=>"function isPrime(n) {\n  \n}",
    'template_py'=>"def isPrime(n):\n  pass",
    'template_cpp'=>"#include <iostream>\n#include <cmath>\n\nbool isPrime(int n) {\n  \n}",
    'template_csharp'=>"using System;\n\nclass Program {\n  static bool isPrime(int n) {\n    \n  }\n}",
    'template_rb'=>"def isPrime(n)\n  \nend",
    'template_go'=>"package main\n\nimport \"math\"\n\nfunc isPrime(n int) bool {\n  \n}",
    'expected_output'=>'true', 'points' => 30],

    ['id'=>4, 'title'=>'Hitung Faktorial', 'description'=>'Buat fungsi `factorial(n)` yang menghitung faktorial dari `n` (n!). Faktorial dari 0 adalah 1.', 'function_name'=>'factorial', 'test_cases'=>[['inputs'=>[5],'expected'=>120],['inputs'=>[0],'expected'=>1],['inputs'=>[7],'expected'=>5040]],
    'template_js'=>"function factorial(n) {\n  \n}",
    'template_py'=>"def factorial(n):\n  pass",
    'template_cpp'=>"#include <iostream>\n\nlong long factorial(int n) {\n  \n}",
    'template_csharp'=>"using System;\n\nclass Program {\n  static long factorial(int n) {\n    \n  }\n}",
    'template_rb'=>"def factorial(n)\n  \nend",
    'template_go'=>"package main\n\nfunc factorial(n int) int {\n  \n}",
    'expected_output'=>'120', 'points' => 25],

    ['id'=>5, 'title'=>'Cek Palindrom', 'description'=>'Buat fungsi `isPalindrome(s)` yang mengembalikan `true` jika string `s` adalah palindrom. Perbandingan tidak case-sensitive (huruf besar/kecil dianggap sama).', 'function_name'=>'isPalindrome', 'test_cases'=>[['inputs'=>['Katak'],'expected'=>true],['inputs'=>['hello'],'expected'=>false],['inputs'=>['Malam'],'expected'=>true],['inputs'=>['Level'],'expected'=>true]],
    'template_js'=>"function isPalindrome(s) {\n  \n}",
    'template_py'=>"def isPalindrome(s):\n  pass",
    'template_cpp'=>"#include <iostream>\n#include <string>\n#include <algorithm>\n\nbool isPalindrome(std::string s) {\n  \n}",
    'template_csharp'=>"using System;\n\nclass Program {\n  static bool isPalindrome(string s) {\n    \n  }\n}",
    'template_rb'=>"def isPalindrome(s)\n  \nend",
    'template_go'=>"package main\n\nimport \"strings\"\n\nfunc isPalindrome(s string) bool {\n  \n}",
    'expected_output'=>'true', 'points' => 20]
,
    ['id'=>6, 'title'=>'Cari Angka Terbesar', 'description'=>'Buat fungsi `findMax(arr)` yang menerima sebuah array angka dan mengembalikan angka terbesar di dalamnya. Jika array kosong, kembalikan `null`.', 'function_name'=>'findMax', 'test_cases'=>[['inputs'=>[[1, 5, 2, 9, 3]],'expected'=>9], ['inputs'=>[[-10, -5, -1, -20]],'expected'=>-1], ['inputs'=>[[]],'expected'=>null]],
    'template_js'=>"function findMax(arr) {\n  \n}",
    'template_py'=>"def findMax(arr):\n  pass",
    'template_cpp'=>"#include <iostream>\n#include <vector>\n#include <optional>\n\nstd::optional<int> findMax(std::vector<int> arr) {\n  \n}",
    'template_csharp'=>"using System;\n\nclass Program {\n  static int? findMax(int[] arr) {\n    \n  }\n}",
    'template_rb'=>"def findMax(arr)\n  \nend",
    'template_go'=>"package main\n\nfunc findMax(arr []int) (*int, error) {\n  \n}",
    'expected_output'=>'9', 'points' => 15],

    ['id'=>7, 'title'=>'Hapus Duplikat', 'description'=>'Buat fungsi `removeDuplicates(arr)` yang menghapus elemen duplikat dari sebuah array dan mengembalikan array baru tanpa duplikat. Urutan elemen tidak harus dipertahankan.', 'function_name'=>'removeDuplicates', 'test_cases'=>[['inputs'=>[[1, 2, 2, 3, 1]],'expected'=>[1, 2, 3]], ['inputs'=>[['a', 'b', 'a']],'expected'=>['a', 'b']], ['inputs'=>[[]],'expected'=>[]]],
    'template_js'=>"function removeDuplicates(arr) {\n  \n}",
    'template_py'=>"def removeDuplicates(arr):\n  pass",
    'template_cpp'=>"#include <iostream>\n#include <vector>\n#include <set>\n\nstd::vector<int> removeDuplicates(std::vector<int> arr) {\n  \n}",
    'template_csharp'=>"using System;\nusing System.Linq;\n\nclass Program {\n  static object[] removeDuplicates(object[] arr) {\n    \n  }\n}",
    'template_rb'=>"def removeDuplicates(arr)\n  \nend",
    'template_go'=>"package main\n\nfunc removeDuplicates(arr []interface{}) []interface{} {\n  \n}",
    'expected_output'=>'[1,2,3]', 'points' => 25],

    ['id'=>8, 'title'=>'FizzBuzz', 'description'=>"Buat fungsi `fizzBuzz(n)` yang mengembalikan sebuah array. Untuk setiap angka dari 1 sampai `n`: jika habis dibagi 3, tambahkan 'Fizz'. Jika habis dibagi 5, tambahkan 'Buzz'. Jika habis dibagi 3 dan 5, tambahkan 'FizzBuzz'. Jika tidak, tambahkan angka itu sendiri (sebagai string).", 'function_name'=>'fizzBuzz', 'test_cases'=>[['inputs'=>[5],'expected'=>['1', '2', 'Fizz', '4', 'Buzz']], ['inputs'=>[15],'expected'=>['1', '2', 'Fizz', '4', 'Buzz', 'Fizz', '7', '8', 'Fizz', 'Buzz', '11', 'Fizz', '13', '14', 'FizzBuzz']]],
    'template_js'=>"function fizzBuzz(n) {\n  \n}",
    'template_py'=>"def fizzBuzz(n):\n  pass",
    'template_cpp'=>"#include <iostream>\n#include <vector>\n#include <string>\n\nstd::vector<std::string> fizzBuzz(int n) {\n  \n}",
    'template_csharp'=>"using System;\nusing System.Collections.Generic;\n\nclass Program {\n  static List<string> fizzBuzz(int n) {\n    \n  }\n}",
    'template_rb'=>"def fizzBuzz(n)\n  \nend",
    'template_go'=>"package main\n\nimport \"strconv\"\n\nfunc fizzBuzz(n int) []string {\n  \n}",
    'expected_output'=>'["1","2","Fizz","4","Buzz"]', 'points' => 20],

    ['id'=>9, 'title'=>'Jumlahkan Isi Array', 'description'=>'Buat fungsi `sumArray(arr)` yang menghitung dan mengembalikan jumlah semua angka dalam sebuah array. Jika array kosong, kembalikan 0.', 'function_name'=>'sumArray', 'test_cases'=>[['inputs'=>[[1, 2, 3, 4]],'expected'=>10], ['inputs'=>[[]],'expected'=>0], ['inputs'=>[[-1, 1, 10]],'expected'=>10]],
    'template_js'=>"function sumArray(arr) {\n  \n}",
    'template_py'=>"def sumArray(arr):\n  pass",
    'template_cpp'=>"#include <iostream>\n#include <vector>\n#include <numeric>\n\nint sumArray(std::vector<int> arr) {\n  \n}",
    'template_csharp'=>"using System;\nusing System.Linq;\n\nclass Program {\n  static int sumArray(int[] arr) {\n    \n  }\n}",
    'template_rb'=>"def sumArray(arr)\n  \nend",
    'template_go'=>"package main\n\nfunc sumArray(arr []int) int {\n  \n}",
    'expected_output'=>'10', 'points' => 10],

    ['id'=>10, 'title'=>'Two Sum', 'description'=>'Diberikan array integer `nums` dan integer `target`, kembalikan indeks dari dua angka yang jumlahnya sama dengan `target`. Anda dapat mengasumsikan bahwa setiap masukan akan memiliki tepat satu solusi, dan Anda tidak boleh menggunakan elemen yang sama dua kali. Urutan indeks tidak penting.', 'function_name'=>'twoSum', 'test_cases'=>[['inputs'=>[[2, 7, 11, 15], 9],'expected'=>[0, 1]], ['inputs'=>[[3, 2, 4], 6],'expected'=>[1, 2]], ['inputs'=>[[3,3], 6],'expected'=>[0, 1]]],
    'template_js'=>"function twoSum(nums, target) {\n  \n}",
    'template_py'=>"def twoSum(nums, target):\n  pass",
    'template_cpp'=>"#include <iostream>\n#include <vector>\n#include <unordered_map>\n\nstd::vector<int> twoSum(std::vector<int>& nums, int target) {\n  \n}",
    'template_csharp'=>"using System;\nusing System.Collections.Generic;\n\nclass Program {\n  static int[] twoSum(int[] nums, int target) {\n    \n  }\n}",
    'template_rb'=>"def twoSum(nums, target)\n  \nend",
    'template_go'=>"package main\n\nfunc twoSum(nums []int, target int) []int {\n  \n}",
    'expected_output'=>'[0,1]', 'points' => 40]
];
if($_SERVER['REQUEST_METHOD']==='POST'&&isset($_GET['action'])){
    header('Content-Type: application/json');
    $action=$_GET['action'];
    $body=json_decode(file_get_contents('php://input'),true)?:[];
    if($action==='score'){
        $qid=intval($body['questionId']??0);
        $correct=boolval($body['correct']??false);
        $points=intval($body['points']??0);
        if(!isset($_SESSION['score']))$_SESSION['score']=0;
        if($correct)$_SESSION['score']+=$points;
        echo json_encode(['ok'=>true,'score'=>$_SESSION['score']]);
        exit;
    }
    if($action==='reset'){
        $_SESSION['score']=0;
        echo json_encode(['ok'=>true]);
        exit;
    }
    if($action==='run'){
        $lang=($body['lang']??'js');
        $code=($body['code']??'');
        $timeout=10;
        $is_submit = !empty($body['submit']);

        if (!$is_submit) {
            $result = executeCode($lang, $code);
            echo json_encode(['ok'=>true,'result'=>$result]);
            exit;
        } else {
            $qid = intval($body['questionId'] ?? 0);
            $question = null;
            foreach ($questions as $q) {
                if ($q['id'] == $qid) {
                    $question = $q;
                    break;
                }
            }

            if (!$question) {
                echo json_encode(['ok' => false, 'msg' => 'Soal tidak ditemukan.']);
                exit;
            }

            $execResult = executeCode($lang, $code);
            $got = trim($execResult['stdout']);
            $expected = trim($question['expected_output']);
            $correct = ($got === $expected);

            $response = [
                'ok' => true,
                'correct' => $correct,
                'stdout' => $got,
                'stderr' => $execResult['stderr'],
                'timed' => $execResult['timed'],
                'points' => 0,
                'score' => $_SESSION['score'] ?? 0
            ];

            if ($correct) {
                $points = $question['points'] ?? 0;
                if(!isset($_SESSION['score']))$_SESSION['score']=0;
                $_SESSION['score'] += $points;
                $response['points'] = $points;
                $response['score'] = $_SESSION['score'];
            }

            echo json_encode($response);
            exit;
        }
    }
    http_response_code(400);echo json_encode(['ok'=>false,'msg'=>'unknown action']);exit;
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Reconit - Coding Quiz</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
<script src="https://cdn.tailwindcss.com"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/ace/1.11.2/ace.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.6.0/dist/confetti.browser.min.js"></script>
<style>
    :root {
        --bg: #0d1117;
        --card: #161b22;
        --accent: #58a6ff;
        --accent-hover: #4695f7;
        --border: #30363d;
    }
    body {
        font-family: 'Inter', sans-serif;
        background-color: var(--bg);
        color: #e6edf3;
        overflow-x: hidden;
    }
    .editor { width: 100%; height: 400px; border-radius: 0.75rem; overflow: hidden; border: 1px solid var(--border); }
    .ace_editor { background-color: #282a36 !important; }
    .ace_gutter { background: #21222c !important; }
    #console .console-line { padding: 2px 6px; border-radius: 4px; margin-bottom: 2px; display: block; white-space: pre-wrap; word-break: break-all; }
    #console .console-error { color: #ff7b72; background-color: rgba(255, 123, 114, 0.1); }
    #console .console-success { color: #7ee787; background-color: rgba(126, 231, 135, 0.1); }
    #console .console-warning { color: #d29922; background-color: rgba(210, 153, 34, 0.1); }
    .pulse { animation: pulse-animation 1.5s cubic-bezier(0.4, 0, 0.6, 1) infinite; }
    @keyframes pulse-animation { 50% { opacity: .5; } }
    .shake { animation: shake-animation 0.5s; }
    @keyframes shake-animation {
        10%, 90% { transform: translate3d(-1px, 0, 0); } 20%, 80% { transform: translate3d(2px, 0, 0); }
        30%, 50%, 70% { transform: translate3d(-4px, 0, 0); } 40%, 60% { transform: translate3d(4px, 0, 0); }
    }
    .glow-success { box-shadow: 0 0 12px 2px rgba(46, 160, 67, 0.5); }
    .glow-error { box-shadow: 0 0 12px 2px rgba(248, 81, 73, 0.5); }
</style>
</head>
<body class="min-h-screen text-gray-200">
<div class="max-w-screen-2xl mx-auto p-4 sm:p-6 lg:p-8">
<header class="flex items-center justify-between mb-8">
<div class="flex items-center flex-1">
    <img src="assets/gambar/logo.png" alt="Reconit-" class="h-12">
</div>
<nav class="flex justify-center flex-1">
    <div class="flex items-center gap-2 bg-[color:var(--card)] border border-[color:var(--border)] p-1 rounded-lg">
        <a href="index.php" class="px-5 py-1.5 rounded-md bg-[color:var(--accent)] text-white font-medium text-sm transition-colors">Quiz</a>
        <a href="compiler.php" class="px-5 py-1.5 rounded-md text-gray-400 hover:text-white hover:bg-white/5 font-medium text-sm transition-colors">Compiler</a>
    </div>
</nav>
<div class="flex-1"></div> <!-- Spacer to center the nav -->
</header>
<main class="grid lg:grid-cols-3 xl:grid-cols-4 gap-8">
<section class="lg:col-span-3 space-y-6">
    <div id="question-card" class="bg-[color:var(--card)] p-6 rounded-xl border border-[color:var(--border)] transition-all duration-300">
    <div class="flex items-center gap-3 mb-4">
    <div class="w-10 h-10 rounded-lg bg-[color:var(--accent)] flex items-center justify-center">
    <span class="font-bold text-white" id="q-id">1</span>
    </div>
    <h2 id="q-title" class="text-2xl font-semibold">Loading...</h2>
    </div>
    <p id="q-desc" class="text-gray-400 whitespace-pre-line leading-relaxed">...</p>
    <div class="mt-4 pt-4 border-t border-[color:var(--border)]">
        <h4 class="font-semibold text-gray-300 mb-2 flex items-center gap-2"><i class="fa-solid fa-bullseye text-[color:var(--accent)]"></i>Expected Output</h4>
        <pre id="q-expected" class="bg-black/30 p-3 rounded-lg text-sm font-mono text-gray-400"></pre>
    </div>
    </div>
    <div class="bg-[color:var(--card)] p-5 rounded-xl border border-[color:var(--border)]">
    <div class="flex flex-wrap gap-4 mb-4 items-center">
    <div class="relative">
    <select id="lang" class="bg-[#0d1117] border border-[color:var(--border)] rounded-lg px-4 py-2.5 appearance-none focus:ring-2 focus:ring-[color:var(--accent)] focus:border-[color:var(--accent)] pr-10">
    <option value="js">JavaScript</option>
    <option value="py">Python</option>
    <option value="cpp">C++</option>
    <!-- <option value="csharp">C#</option> -->
    <option value="rb">Ruby</option>
    <option value="go">Go</option>
    </select>
    <div class="absolute inset-y-0 right-0 flex items-center px-2 pointer-events-none">
    <i class="fa-solid fa-chevron-down text-gray-400"></i>
    </div>      
    </div>
    </div>
    <div id="editor" class="editor mb-4"></div>
    <div class="flex gap-4">
    <button id="run-btn" class="px-6 py-3 rounded-lg bg-[color:var(--accent)] hover:bg-[color:var(--accent-hover)] text-white font-medium flex items-center gap-2 transition-colors">
    <i class="fa-solid fa-play"></i> Run Code
    </button>
    <button id="submit-btn" class="px-6 py-3 rounded-lg border border-[color:var(--border)] text-white font-medium flex items-center gap-2 transition hover:bg-white/10">
    <i class="fa-solid fa-paper-plane"></i> Submit Answer
    </button>
    </div>
    <div class="mt-6">
    <div class="flex items-center gap-2 mb-3">
    <i class="fa-solid fa-terminal text-gray-400"></i>
    <h3 class="font-semibold">Console Output</h3>
    </div>
    <div class="bg-black/30 p-2 rounded-lg border border-[color:var(--border)]">
    <pre id="console" class="text-sm font-mono overflow-auto max-h-48"></pre>
    </div>
    </div>
    </div>
</section>
<aside class="lg:col-span-1 space-y-6">
    <div class="bg-[color:var(--card)] p-5 rounded-xl border border-[color:var(--border)]">
    <div class="flex items-center gap-2 mb-4">
    <i class="fa-solid fa-list-ol text-[color:var(--accent)]"></i>
    <h3 class="font-semibold">Daftar Soal</h3>
    </div>
    <ul id="question-list" class="space-y-3"></ul>
    <div class="mt-4 flex items-center justify-between">
        <button id="page-prev-btn" class="px-3 py-1 rounded-md bg-[#0d1117] border border-[color:var(--border)] text-sm transition hover:border-gray-600 disabled:opacity-50 disabled:cursor-not-allowed">
            <i class="fa-solid fa-chevron-left"></i>
        </button>
        <span id="page-info" class="text-xs text-gray-400"></span>
        <button id="page-next-btn" class="px-3 py-1 rounded-md bg-[#0d1117] border border-[color:var(--border)] text-sm transition hover:border-gray-600 disabled:opacity-50 disabled:cursor-not-allowed">
            <i class="fa-solid fa-chevron-right"></i>
        </button>
    </div>
    </div>
    <div class="bg-[color:var(--card)] p-5 rounded-xl border border-[color:var(--border)]">
    <div class="flex items-center gap-2 mb-4">
    <i class="fa-solid fa-sliders text-[color:var(--accent)]"></i>
    <h3 class="font-semibold">Kontrol</h3>
    </div>
    <div class="grid grid-cols-2 gap-3">
    <button id="prev-btn" class="px-4 py-3 rounded-lg bg-[#0d1117] border border-[color:var(--border)] flex items-center justify-center gap-2 transition hover:border-gray-600">
    <i class="fa-solid fa-arrow-left"></i> Prev
    </button>
    <button id="next-btn" class="px-4 py-3 rounded-lg bg-[#0d1117] border border-[color:var(--border)] flex items-center justify-center gap-2 transition hover:border-gray-600">
    Next <i class="fa-solid fa-arrow-right"></i>
    </button>
    <button id="reset-score" class="col-span-2 px-4 py-3 rounded-xl bg-red-600/20 text-red-400 flex items-center justify-center gap-2 transition hover:bg-red-600/30">
    <i class="fa-solid fa-rotate"></i> Reset Score
    </button>
    </div>
    </div>
    <div class="bg-[color:var(--card)] p-5 rounded-xl border border-[color:var(--border)] text-sm text-gray-400">
    <div class="flex items-center gap-2 mb-3">
    <i class="fa-solid fa-circle-info text-[color:var(--accent)]"></i>
    <h3 class="font-semibold">Petunjuk</h3>
    </div>
    <ul class="space-y-2">
    <li class="flex items-start gap-2">
    <i class="fa-solid fa-circle-play mt-1 text-[color:var(--accent)] text-xs"></i>
    <span>Pilih bahasa dan klik <strong>Run Code</strong> untuk melihat output.</span>
    </li>
    <li class="flex items-start gap-2">
    <i class="fa-solid fa-paper-plane mt-1 text-[color:var(--accent)] text-xs"></i>
    <span>Klik <strong>Submit Answer</strong> untuk menilai jawaban. Jika output sesuai, Anda akan mendapatkan poin.</span>
    </li>
    <li class="flex items-start gap-2">
    <i class="fa-solid fa-rotate mt-1 text-[color:var(--accent)] text-xs"></i>
    <span><strong>Reset Score</strong> akan mengatur ulang poin Anda menjadi nol.</span>
    </li>
    </ul>
    </div>
</aside>
</main>
</div>
<script>
    const QUESTIONS = <?php echo json_encode($questions, JSON_UNESCAPED_UNICODE); ?>;
</script>
<script src="assets/js/script.js"></script>
</body>
</html>